// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Oleserver.pas' rev: 10.00

#ifndef OleserverHPP
#define OleserverHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Activex.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Comobj.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Oleserver
{
//-- type declarations -------------------------------------------------------
typedef DynamicArray<OleVariant >  TVariantArray;

#pragma option push -b-
enum TConnectKind { ckRunningOrNew, ckNewInstance, ckRunningInstance, ckRemote, ckAttachToInterface };
#pragma option pop

class DELPHICLASS TServerEventDispatch;
class DELPHICLASS TOleServer;
struct TServerData;
typedef TServerData *PServerData;

class PASCALIMPLEMENTATION TOleServer : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TServerData *FServerData;
	int FRefCount;
	TServerEventDispatch* FEventDispatch;
	int FEventsConnection;
	bool FAutoConnect;
	AnsiString FRemoteMachineName;
	TConnectKind FConnectKind;
	
protected:
	virtual HRESULT __stdcall QueryInterface(const GUID &IID, /* out */ void *Obj);
	HIDESBASE int __stdcall _AddRef(void);
	HIDESBASE int __stdcall _Release(void);
	virtual void __fastcall Loaded(void);
	virtual void __fastcall InitServerData(void) = 0 ;
	virtual System::_di_IInterface __fastcall GetServer();
	void __fastcall ConnectEvents(const System::_di_IInterface Obj);
	void __fastcall DisconnectEvents(const System::_di_IInterface Obj);
	virtual void __fastcall InvokeEvent(int DispID, TVariantArray &Params);
	TConnectKind __fastcall GetConnectKind(void);
	void __fastcall SetConnectKind(TConnectKind ck);
	bool __fastcall GetAutoConnect(void);
	void __fastcall SetAutoConnect(bool flag);
	__property PServerData ServerData = {read=FServerData, write=FServerData};
	__property TServerEventDispatch* EventDispatch = {read=FEventDispatch, write=FEventDispatch};
	
public:
	__fastcall virtual TOleServer(Classes::TComponent* AOwner);
	__fastcall virtual ~TOleServer(void);
	virtual void __fastcall Connect(void) = 0 ;
	virtual void __fastcall Disconnect(void) = 0 ;
	
__published:
	__property bool AutoConnect = {read=GetAutoConnect, write=SetAutoConnect, nodefault};
	__property TConnectKind ConnectKind = {read=GetConnectKind, write=SetConnectKind, nodefault};
	__property AnsiString RemoteMachineName = {read=FRemoteMachineName, write=FRemoteMachineName};
private:
	void *__IInterface;	/* System::IInterface */
	
public:
	operator IInterface*(void) { return (IInterface*)&__IInterface; }
	
};


class PASCALIMPLEMENTATION TServerEventDispatch : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TOleServer* FServer;
	int InternalRefCount;
	
protected:
	HRESULT __stdcall QueryInterface(const GUID &IID, /* out */ void *Obj);
	int __stdcall _AddRef(void);
	int __stdcall _Release(void);
	HRESULT __stdcall GetTypeInfoCount(/* out */ int &Count);
	HRESULT __stdcall GetTypeInfo(int Index, int LocaleID, /* out */ void *TypeInfo);
	HRESULT __stdcall GetIDsOfNames(const GUID &IID, void * Names, int NameCount, int LocaleID, void * DispIDs);
	HRESULT __stdcall Invoke(int DispID, const GUID &IID, int LocaleID, Word Flags, void *Params, void * VarResult, void * ExcepInfo, void * ArgErr);
	__property TOleServer* Server = {read=FServer};
	bool __fastcall ServerDisconnect(void);
	
public:
	__fastcall TServerEventDispatch(TOleServer* Server);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TServerEventDispatch(void) { }
	#pragma option pop
	
private:
	void *__IDispatch;	/* IDispatch */
	
public:
	operator IDispatch*(void) { return (IDispatch*)&__IDispatch; }
	operator IInterface*(void) { return (IInterface*)&__IDispatch; }
	
};


struct TServerData
{
	
public:
	#pragma pack(push,1)
	GUID ClassID;
	#pragma pack(pop)
	#pragma pack(push,1)
	GUID IntfIID;
	#pragma pack(pop)
	#pragma pack(push,1)
	GUID EventIID;
	#pragma pack(pop)
	void *LicenseKey;
	int Version;
	int InstanceCount;
} ;

//-- var, const, procedure ---------------------------------------------------

}	/* namespace Oleserver */
using namespace Oleserver;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Oleserver
